package gov.va.genisis2.model;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class WorkflowStatus.
 * 
 * Description: In this WorkflowStatus Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "WorkflowStatus", schema = "dbo")
public class WorkflowStatus implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 8856871498976013089L;

	/** The id. */
	private int id;
	
	/** The description. */
	private String description;
	
	/** The comment histories. */
	private Set<CommentHistory> commentHistories = new HashSet<>(0);

	/**
	 * Instantiates a new workflow status.
	 */
	public WorkflowStatus() {
		// Do nothing. The method is an intentionally-blank override.
		}

	/**
	 * Instantiates a new workflow status.
	 *
	 * @param id the id
	 */
	public WorkflowStatus(int id) {
		this.id = id;
	}

	/**
	 * Instantiates a new workflow status.
	 *
	 * @param id the id
	 * @param description the description
	 * @param commentHistories the comment histories
	 */
	public WorkflowStatus(int id, String description, Set<CommentHistory> commentHistories) {
		this.id = id;
		this.description = description;
		this.commentHistories = commentHistories;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	@Column(name = "Description", length = 50)
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Gets the comment histories.
	 *
	 * @return the comment histories
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "workflowStatus")
	public Set<CommentHistory> getCommentHistories() {
		return this.commentHistories;
	}

	/**
	 * Sets the comment histories.
	 *
	 * @param commentHistories the new comment histories
	 */
	public void setCommentHistories(Set<CommentHistory> commentHistories) {
		this.commentHistories = commentHistories;
	}

}
